-- MusicWheelItem Song(/Course)
local t = Def.ActorFrame{
	Def.Sprite{
		InitCommand=cmd(setsize,218,88);
		SetMessageCommand=function(self,params)
			self:Load( GetEmblemFromSongTitle("Default") );
			local song = params.Song;
			if song then
				local title = song:GetDisplayFullTitle();
				Trace("AJ DEBUG: title = ".. title);
				self:Load( GetEmblemFromSongTitle(title) );
				
				-- check song length
				if song:IsLong() then
					self:diffuse( SongLengthColors.Long );
				elseif song:IsMarathon() then
					self:diffuse( SongLengthColors.Marathon );
				else
					self:diffuse( SongLengthColors.Normal );
				end;
			end;
		end;
	};
	-- draw edges over quad
	LoadActor( THEME:GetPathG("_shared","MusicWheelItem/_top") );
	LoadActor( THEME:GetPathG("_shared","MusicWheelItem/_bot") );
};


-- rewrite

-- actorframe for the difficulties
local u = Def.ActorFrame{};

--[[
internal note to self:
You're going to have to be able to account for all of the possible
play modes now that AutoStyle is on. It would also help to do the same thing
for gametypes since this theme will be multi-gametype in the future.

I'm thinking of wrapping the difficulty pairs in style pairs, only working with
singles and doubles modes. (this includes pump's halfdoubles because that is
the absolute best mode ever)
]]

-- define possible gametypes and their steps types to check for here:
local GameStepTypes = {
	dance = { 'StepsType_Dance_Single', 'StepsType_Dance_Double' },
	pump = { 'StepsType_Pump_Single', 'StepsType_Pump_Halfdouble', 'StepsType_Pump_Double' },
	-- todo: other modes? maaaaaaaaybe. doubt it though.
	-- beatmania in stepmania is nothanksmania to me!
};

local GameDifficulties = {
	StepsType_Dance_Single = { 'Difficulty_Beginner','Difficulty_Easy','Difficulty_Medium','Difficulty_Hard','Difficulty_Challenge' },
	StepsType_Dance_Double = { 'Difficulty_Beginner','Difficulty_Easy','Difficulty_Medium','Difficulty_Hard','Difficulty_Challenge' },
	StepsType_Pump_Single = { 'Difficulty_Beginner','Difficulty_Easy','Difficulty_Medium','Difficulty_Hard' },
	StepsType_Pump_Halfdouble = { 'Difficulty_Medium' },
	StepsType_Pump_Double = { 'Difficulty_Medium','Difficulty_Hard' }
};

-- define the positions for all possible meters
local MeterPositions = {
	StepsType_Dance_Single = { -100, -81, -62, -43, -24 },
	StepsType_Dance_Double = { 24, 43, 62, 81, 100 },
};
-- and for the labels [provisional]
local STLabel = {
	StepsType_Dance_Single = { "S", -115 }, -- originally -6
	StepsType_Dance_Double = { "D", 116 }   -- originally 6
};

-- get the game name to use as a key for the above
local thisGame = GAMESTATE:GetCurrentGame():GetName();

--DifficultyAndStepsTypeToColor(difficulty, stepsType)

for gIdx, gST in pairs(GameStepTypes[thisGame]) do
	-- haha single, double
	u[#u+1] = LoadFont("_pf tempesta seven 8px")..{
		Text=STLabel[gST][1];
		InitCommand=cmd(x,STLabel[gST][2];y,52;PixelFont;diffuse,color("#000000");diffusetopedge,color("#888888"));
	};
	for gdIdx, gdDiff in pairs(GameDifficulties[gST]) do
		if not GAMESTATE:IsCourseMode() then
			u[#u+1] = LoadActor( "_boff" ) .. {
				InitCommand=cmd(y,52;playcommand,"SetMessage");
				ShowCommand=cmd(); -- intentionally blank
				HideCommand=cmd(diffuse,color("0.75,0.75,0.75,0.5"));
				BeginCommand=function(self)
					self:x(MeterPositions[gST][gdIdx]);
				end;
				SetMessageCommand=function(self,params)
					local song = params.Song;
					-- if there isn't a song or course, don't bother.
					if not song then return end;
					
					local bHasStepsTypeAndDifficulty =
						song and song:HasStepsTypeAndDifficulty( gST, gdDiff );
					
					local steps = song:GetOneSteps(gST,gdDiff);
					self:diffuse( DifficultyAndStepsTypeToColor(gdDiff, gST) );
					
					self:playcommand( bHasStepsTypeAndDifficulty and "Show" or "Hide" );
				end;
			};
			
			u[#u+1] = LoadFont("_pf tempesta seven 8px")..{
			InitCommand=cmd(y,52;blend,'BlendMode_Add';playcommand,"SetMessage";PixelFont);
			ShowCommand=cmd(visible,true);
			HideCommand=cmd(visible,false);
			BeginCommand=function(self)
				self:x(MeterPositions[gST][gdIdx] + 1);
				--[[
				to consider: manual tweaking based on meter?
				+1 seems to work well for 2-10
				1 could stand to stay the same
				anything over 19 would have to be repositioned because then
				we're dealing with two pretty wide numbers (aside from 21)
				also lol mungyodance songs do i serious
				]]
			end;
			SetMessageCommand=function(self,params)
				local song = params.Song;
				-- if there isn't a song or course, don't bother.
				if not song then return end;
				
				local bHasStepsTypeAndDifficulty =
						song and song:HasStepsTypeAndDifficulty( gST, gdDiff );
				
				self:playcommand( bHasStepsTypeAndDifficulty and "Show" or "Hide" );
				local steps = song:GetOneSteps(gST,gdDiff);
				if steps then self:settext( steps:GetMeter() ); end;
			end;
			};
		end;
	end;
end;

t[#t+1] = u;

return t;